unit HTTPServerMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdGlobal, IdBaseComponent, IdComponent, IdCustomTCPServer,
  IdCustomHTTPServer, IdHTTPServer, SelectCipherSuitesFrame, IdServerIOHandler,
  IdSSL, StreamSec.Mobile.X509Comp,
  StreamSec.Mobile.TlsInternalServer, StreamSec.Mobile.StreamSecII, IdContext,
  IdScheduler, IdSchedulerOfThread, IdSchedulerOfThreadDefault,
  smTLSId10D29IOHandler;

type
  TfrmMain = class(TForm)
    IdHTTPServer1: TIdHTTPServer;
    btnStart: TButton;
    btnStop: TButton;
    TfrmSelectCipherSuites1: TfrmSelectCipherSuites;
    smSimpleTLSInternalServer1: TsmSimpleTLSInternalServer;
    smTLSIdServerIOHandler1: TsmTLSIdServerIOHandler;
    IdSchedulerOfThreadDefault1: TIdSchedulerOfThreadDefault;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure IdHTTPServer1AfterBind(Sender: TObject);
    procedure IdHTTPServer1CommandGet(AContext: TIdContext; ARequestInfo:
        TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo);
    procedure IdHTTPServer1Connect(AContext: TIdContext);
    procedure IdHTTPServer1QuerySSLPort(APort: TIdPort; var VUseSSL: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  stSecUtils, StreamSec.Mobile.Tls;

{$R *.dfm}

procedure TfrmMain.btnStartClick(Sender: TObject);
begin
  smSimpleTLSInternalServer1.Options := TfrmSelectCipherSuites1.Options;
  smSimpleTLSInternalServer1.TLSSetupServer;
  IdHTTPServer1.StartListening;
end;

procedure TfrmMain.btnStopClick(Sender: TObject);
begin
  IdHTTPServer1.StopListening;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  smSimpleTLSInternalServer1.ImportFromPFX('Server.pfx',TSecretKey.CreateBMPStr('abc',3));
  smSimpleTLSInternalServer1.Options.KeyAgreementRSA := prAllowed;
  smSimpleTLSInternalServer1.Options.KeyAgreementECDHE := prPrefer;
  smSimpleTLSInternalServer1.Options.BulkCipherAES128 := prAllowed;
  smSimpleTLSInternalServer1.Options.BulkCipherTripleDES := prNotAllowed;
  smSimpleTLSInternalServer1.Options.BulkCipherAES192 := prNotAllowed;
  smSimpleTLSInternalServer1.Options.BulkCipherAES256 := prNotAllowed;
  smSimpleTLSInternalServer1.Options.SignatureRSA := prPrefer;
  smSimpleTLSInternalServer1.Options.RequestClientCertificate := False;
  smSimpleTLSInternalServer1.Options.RequireClientCertificate := False;
  smSimpleTLSInternalServer1.Options.ServerSelectsCipherSuite := True;
  smSimpleTLSInternalServer1.IncludeRootInTLSChain := False;
  smSimpleTLSInternalServer1.TLSSetupServer;
  TfrmSelectCipherSuites1.Options := smSimpleTLSInternalServer1.Options;
end;

procedure TfrmMain.IdHTTPServer1AfterBind(Sender: TObject);
begin
  //
end;

procedure TfrmMain.IdHTTPServer1CommandGet(AContext: TIdContext; ARequestInfo:
    TIdHTTPRequestInfo; AResponseInfo: TIdHTTPResponseInfo);
var
  lTLSSocket: TCustomTLSIdSock;
begin
  lTLSSocket := TsmTLSIdIOHandlerSocket(AContext.Connection.IOHandler).TLSSocket;
  AResponseInfo.ContentText := '<html><head><title>OK</title></head><body>' +
   'Host: ' + ARequestInfo.Host + '<br/>'#13#10 +
   'Path: ' + ARequestInfo.Document + '<br/>'#13#10 +
   'CipherSuite: ' + GetCipherSuiteName(lTLSSocket.SelectedCipherSuite,lTLSSocket.Version,True) +  '<br/>'#13#10 +
   '</body></html>';
 AResponseInfo.ResponseNo := 200;
end;

procedure TfrmMain.IdHTTPServer1Connect(AContext: TIdContext);
begin
  //
end;

procedure TfrmMain.IdHTTPServer1QuerySSLPort(APort: TIdPort;
  var VUseSSL: Boolean);
begin
  VUseSSL := True;
end;

end.
